Rem  Copyright (c) 1998 by Oracle Corporation 
Rem    NAME
Rem     WordSolutionDemo.sql - Make use of APIs exposed by WordSolution.sql
Rem    DESCRIPTION
REM		Gives a little demonstration on using the Oracle COM callouts capabilities of
REM		Oracle. Connects to the scott/tiger database and construct a text message from it and
REM		storing it in a Word document whose file is saved as c:\WordDemo.doc. 
REM	
REM    MODIFIED   (MM/DD/YY)
REM     kfleong	   01/12/98 -  Creation
REM
REM	

set serveroutput on;
declare 
result1 emp.EMPNO%TYPE;
	CURSOR c1 IS	
		SELECT EMPNO, ENAME, JOB, SAL, HIREDATE FROM emp;

i binary_integer;
datevalue DATE;
cellValue varchar2(255);

filename varchar(255);

begin

filename:='c:\worddemo';

i:=ORDWord.CreateWordObject('');

i:=ORDWord.FileNew();
i:=ORDWord.FormatFontSize(22);
i:=ORDWord.InsertText('Oracle COM Data Cartridge - Microsoft Word Solution.');
i:=ORDWord.InsertNewLine();
i:=ORDWord.InsertNewLine();
i:=ORDWord.FormatFontSize(14);
i:=ORDWord.InsertText('The names of the employees found in your database are ');


For c1_rec IN c1 LOOP

cellValue:=TO_CHAR(c1_rec.EMPNO);
cellValue:=c1_rec.ENAME;
i:=ORDWord.InsertText(cellValue);
i:=ORDWord.InsertText(', ');

cellValue:=c1_rec.JOB;
cellValue:=c1_rec.SAL;
dateValue:=c1_rec.HIREDATE;

END LOOP;


i:=ORDWord.InsertNewLine();
i:=ORDWord.InsertNewLine();
i:=ORDWord.FormatFontSize(12);
i:=ORDWord.InsertText('This solution demonstrates the ability of the COM Data Cartridge to exchange data between Oracle and Microsoft Word.');
i:=ORDWord.InsertText('A developer can extend the capabilities of these demo solutions and customize them for their particular needs.');

i:=ORDWord.FileSaveAs(filename);

i:=ORDWord.FileClose();



end;
